import 'package:flutter/material.dart';
import 'package:get/get.dart';
import 'package:viser_remit/core/utils/my_color.dart';
import 'package:viser_remit/core/utils/my_strings.dart';
import 'package:viser_remit/core/utils/style.dart';
import 'package:viser_remit/data/controller/send_money/send_money_controller.dart';
import 'package:viser_remit/data/repo/send_money/send_money_repo.dart';
import 'package:viser_remit/view/components/app-bar/viser_remit_app_bar.dart';
import 'package:viser_remit/view/components/custom_loader/custom_loader.dart';
import 'package:viser_remit/view/screens/send_money/recipient_screen.dart';
import 'package:viser_remit/view/screens/send_money/sender_screen.dart';

import '../../../data/services/api_client.dart';

class SendMoneyScreen extends StatefulWidget {
  const SendMoneyScreen({super.key});

  @override
  State<SendMoneyScreen> createState() => _SendMoneyScreenState();
}

class _SendMoneyScreenState extends State<SendMoneyScreen> with SingleTickerProviderStateMixin {
  TabController? tabController;

  @override
  void initState() {
    Get.put(ApiClient(sharedPreferences: Get.find()));
    Get.put(SendMoneyRepo(apiClient: Get.find()));
    final controller = Get.put(SendMoneyController(sendMoneyRepo: Get.find()));
    super.initState();
    tabController = TabController(length: 2, vsync: this, initialIndex: 0);

    WidgetsBinding.instance.addPostFrameCallback((timeStamp) {
      controller.loadSendMoneyData();
    });
  }

  @override
  Widget build(BuildContext context) {
    return GetBuilder<SendMoneyController>(
      builder: (controller) => Scaffold(
        appBar: ViserRemitAppBar(
          title: MyStrings.sendMoney.tr,
          isElevation: true,
          appBarHeight: 80,
        ),
        body: controller.isLoading
            ? const CustomLoader()
            : Container(
                padding: const EdgeInsets.symmetric(horizontal: 16),
                width: double.infinity,
                height: double.infinity,
                child: Column(
                  children: [
                    Expanded(
                      flex: 1,
                      child: Padding(
                        padding: const EdgeInsets.all(8.0),
                        child: TabBar(
                          labelColor: MyColor.primaryColor,
                          automaticIndicatorColorAdjustment: true,
                          controller: tabController,
                          unselectedLabelColor: Colors.grey,
                          indicatorColor: MyColor.primaryColor,
                          labelStyle: boldLarge,
                          tabs: [
                            Tab(
                              text: MyStrings.senderInformation.tr,
                            ),
                            Tab(
                              text: MyStrings.recipientInformation.tr,
                            ),
                          ],
                        ),
                      ),
                    ),
                    Expanded(
                      flex: 12,
                      child: TabBarView(
                        controller: tabController,
                        children: const [SenderScreen(), RecipientScreen()],
                      ),
                    )
                  ],
                ),
              ),
      ),
    );
  }
}
